--[[
    SetIsReconfiguringEvent

    Multiplayer Sync Event for isReconfiguring state of vehicles.

	@author: 		BayernGamers
	@date: 			17.07.2025
	@version:		1.0

	History:		v1.0 @17.07.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------
	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage: 
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

SetIsReconfiguringEvent = {}

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "SetIsReconfiguringEvent.lua")
local SetIsReconfiguringEvent_mt = Class(SetIsReconfiguringEvent, Event)

InitEventClass(SetIsReconfiguringEvent, "SetIsReconfiguringEvent")

function SetIsReconfiguringEvent:emptyNew()
    local self = Event.new(SetIsReconfiguringEvent_mt)
    return self
end

function SetIsReconfiguringEvent.new(vehicle, isReconfiguring)
    local self = SetIsReconfiguringEvent:emptyNew()
    self.vehicle = vehicle
    self.isReconfiguring = isReconfiguring

    return self
end

function SetIsReconfiguringEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteBool(streamId, self.isReconfiguring)
end

function SetIsReconfiguringEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.isReconfiguring = streamReadBool(streamId)

    self:run(connection)
end

function SetIsReconfiguringEvent:run(connection)
    log:printDevInfo(string.format("SetIsReconfiguringEvent:run - vehicle %s, isReconfiguring %s", self.vehicle:getName(), tostring(self.isReconfiguring)), LoggingUtil.DEBUG_LEVELS.HIGH)
    if connection:getIsServer() then
        log:printDevInfo("IsServer", LoggingUtil.DEBUG_LEVELS.HIGH)
        if self.vehicle ~= nil then
            self.vehicle.isReconfiguring = self.isReconfiguring
            log:printDevInfo(string.format("Set isReconfiguring for vehicle %s to %s", self.vehicle:getName(), tostring(self.isReconfiguring)), LoggingUtil.DEBUG_LEVELS.HIGH)
        end
    end
end