--[[
    HookLiftTrailerExtension

    Reworks the HookLiftTrailer to not allow unloading the container if hoses are attached.

	@author: 		BayernGamers
	@date: 			10.09.2025
	@version:		1.0

	History:		v1.0 @10.09.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "HookLiftTrailerExtension.lua")

HookLiftTrailerExtension = {}
HookLiftTrailerExtension.MOD_DIRECTORY = g_currentModDirectory
HookLiftTrailerExtension.MOD_NAME = g_currentModName

function HookLiftTrailerExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(HookLiftTrailer, specializations) and SpecializationUtil.hasSpecialization(AttachConnectionHosesManually, specializations)
end

function HookLiftTrailerExtension.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", HookLiftTrailerExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", HookLiftTrailerExtension)
end

function HookLiftTrailerExtension.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getIsFoldAllowed", HookLiftTrailerExtension.getIsFoldAllowed)
end

function HookLiftTrailerExtension:onPreLoad(savegame)
    self.spec_hookLiftTrailerExtension = {}
    local spec = self.spec_hookLiftTrailerExtension

    spec.modSettingsManager = AttachImplementsManuallySettingsManager.getInstance()
end

function HookLiftTrailerExtension:onPostLoad(savegame)
    local spec = self.spec_hookLiftTrailerExtension

    if SpecializationUtil.hasSpecialization(ConnectionHoses, self.specializations) then
        local spec_connectionHoses = self.spec_connectionHoses

        spec.hasConnectionHoses = #spec_connectionHoses.toolConnectorHoses > 0 or #spec_connectionHoses.hoseNodes > 0 or #spec_connectionHoses.customHoseTargets > 0 or #spec_connectionHoses.customHoses > 0 or #spec_connectionHoses.hoseSkipNodes > 0
    end
end

function HookLiftTrailerExtension:getIsFoldAllowed(superFunc, direction, onAiTurnOn)
    local spec = self.spec_hookLiftTrailerExtension
    local spec_hookLiftTrailer = self.spec_hookLiftTrailer

    if spec.modSettingsManager:getEnableAttachImplementsManually() and not AttachImplementsManually.getIsManualAttachForNexatDisabled(self) then
        if spec.hasConnectionHoses and spec_hookLiftTrailer.attachedContainer ~= nil and spec_hookLiftTrailer.attachedContainer.implement ~= nil then

            local attachedVehicle = spec_hookLiftTrailer.attachedContainer.implement.object
            local hasConnectionHoses = false
            if SpecializationUtil.hasSpecialization(ConnectionHoses, attachedVehicle.specializations) then
                local spec_connectionHoses = attachedVehicle.spec_connectionHoses

                if spec_connectionHoses ~= nil then
                    hasConnectionHoses = #spec_connectionHoses.toolConnectorHoses > 0 or #spec_connectionHoses.hoseNodes > 0 or #spec_connectionHoses.customHoseTargets > 0 or #spec_connectionHoses.customHoses > 0 or #spec_connectionHoses.hoseSkipNodes > 0
                end
            end

            local implementIndex = self:getImplementIndexByObject(attachedVehicle)
            local jointDescIndex = self:getAttacherJointIndexFromImplementIndex(implementIndex)

            if jointDescIndex ~= nil and self.spec_attachConnectionHosesManually ~= nil and self.spec_attachConnectionHosesManually.attachedHoses ~= nil then
                local hasSkipNodeConnection = AttachConnectionHosesManually.getHasSkipNodeConnection(self)

                if self.spec_attachConnectionHosesManually.attachedHoses[jointDescIndex] ~= nil or hasSkipNodeConnection then
                    return false, g_i18n:getText("warning_detachHosesFirst"), true
                end
            end
        end
    end

    return superFunc(self, direction, onAiTurnOn)
end