--[[
    ContextActionDisplayExtension

    Extends the ContextActionDisplay behavior of the AttacherJoints context action.

	@author: 		BayernGamers
	@date: 			31.05.2025
	@version:		1.0

	History:		v1.0 @31.05.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/AttachImplementsManuallySettingsManager.lua", g_currentModDirectory))

ContextActionDisplayExtension = {}

function ContextActionDisplayExtension:updateActionEvents(superFunc)
    local spec = self.spec_attacherJoints
    local info = spec.attachableInfo
    local modSettingsManager = AttachImplementsManuallySettingsManager.getInstance()

    if self.isClient then
        if spec.actionEvents ~= nil then
            local attachActionEvent = spec.actionEvents[InputAction.ATTACH]
            if attachActionEvent ~= nil then
                local visible = false

                if self:getCanToggleAttach() then
                    if info.warning ~= nil then
                        g_currentMission:showBlinkingWarning(info.warning, 500)
                    end

                    local text = ""
                    local prio = GS_PRIO_VERY_LOW

                    local selectedVehicle = self:getSelectedVehicle()
                    if selectedVehicle ~= nil and not selectedVehicle.isDeleted and selectedVehicle.isDetachAllowed ~= nil and selectedVehicle:isDetachAllowed() then
                        if selectedVehicle:getAttacherVehicle() ~= nil then
                            visible = true
                            text = spec.texts.actionDetach
                        end
                    end

                    if info.attacherVehicle ~= nil then
                        if g_currentMission.accessHandler:canFarmAccess(self:getActiveFarm(), info.attachable) then
                            visible = true
                            text = spec.texts.actionAttach

                            if (SpecializationUtil.hasSpecialization(Cutter, info.attachable.specializations) and not SpecializationUtil.hasSpecialization(Combine, info.attachable.specializations)) 
                                or AttacherJointUtil.getUsesFrontloaderToolAttacher(info) or not modSettingsManager:getEnableAttachImplementsManually() or AttachImplementsManually.getIsManualAttachForNexatDisabled(self)
                                or AttacherJointUtil.getAllowsAttachFromInside(info) or AttacherJointUtil.getUsesHookLiftAttacher(info) or AttacherJointUtil.getUsesBigBagAttacher(info)
                            then
                                g_currentMission:showAttachContext(info.attachable)
                            else
                                g_currentMission:showExitToAttachContext()
                            end
                            
                            prio = GS_PRIO_VERY_HIGH
                        else
                            spec.showAttachNotAllowedText = 100
                        end
                    end

                    g_inputBinding:setActionEventText(attachActionEvent.actionEventId, text)
                    g_inputBinding:setActionEventTextPriority(attachActionEvent.actionEventId, prio)
                end

                g_inputBinding:setActionEventTextVisibility(attachActionEvent.actionEventId, visible)
            end

            local lowerActionEvent = spec.actionEvents[InputAction.LOWER_IMPLEMENT]
            if lowerActionEvent ~= nil then
                local showLower = false
                local text = ""
                local selectedImplement = self:getSelectedImplement()
                if selectedImplement ~= nil then
                    for _, attachedImplement in pairs(spec.attachedImplements) do
                        if attachedImplement == selectedImplement then
                            showLower, text = attachedImplement.object:getLoweringActionEventState()
                            break
                        end
                    end
                elseif #spec.attachedImplements == 1 then
                    local attachedImplement = spec.attachedImplements[1]
                    showLower, text = attachedImplement.object:getLoweringActionEventState()
                end

                g_inputBinding:setActionEventActive(lowerActionEvent.actionEventId, showLower)
                g_inputBinding:setActionEventText(lowerActionEvent.actionEventId, text)
                g_inputBinding:setActionEventTextPriority(lowerActionEvent.actionEventId, GS_PRIO_NORMAL)
            end
        end
    end
end

function HUD:showDetachContext(text)
	local actionText = g_i18n:getText("input_DETACH")
	self.contextActionDisplay:setContext(InputAction.ATTACH, ContextActionDisplay.CONTEXT_ICON.ATTACH, text, HUD.CONTEXT_PRIORITY.LOW, actionText)
end

function HUD:showExitToAttachContext()
    local text = g_i18n:getText("action_exitToAttach")
    local actionText = g_i18n:getText("input_ATTACH")
    self.contextActionDisplay:setContext(InputAction.ENTER, ContextActionDisplay.CONTEXT_ICON.ATTACH, text, HUD.CONTEXT_PRIORITY.LOW, actionText)
end

function FSBaseMission:showDetachContext(vehicle)
	self.hud:showDetachContext(vehicle:getUppercaseName())
end

function FSBaseMission:showExitToAttachContext()
    self.hud:showExitToAttachContext()
end

AttacherJoints.updateActionEvents = Utils.overwrittenFunction(AttacherJoints.updateActionEvents, ContextActionDisplayExtension.updateActionEvents)