HeapPreview = {};
HeapPreview.modDir = g_currentModDirectory;
HeapPreview.settingsDir = getUserProfileAppPath().. "modSettings/FS25_HeapPreview/";
--fix player 10.01.2021 (join a player LS19) by HappyLooser
HeapPreview.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "Heap Preview",
	notes = "Zeigt Aktuelle Fruchtart/Volumen von Haufen an",
	author = "(by HappyLooser)",
	version = "1.0.0.0",	
	build = 88,
	datum = "24.11.2016",
	update = "01.12.2024",
	web = "no",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function HeapPreview:loadMap(name)		
	print("---loading ".. tostring(HeapPreview.metadata.title).. " ".. tostring(HeapPreview.metadata.version).. "(#".. tostring(HeapPreview.metadata.build).. ") ".. tostring(HeapPreview.metadata.author).. "---")
	if not HeapPreview:getServer() then	
		HeapPreview.hlDebugMode = false;
		loadScripts(1);
		hpSetGet:generateDisplay();		
		HeapPreview:loadSettings();
		HeapPreview:registerActionEvent();
		Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, HeapPreview.onStartMission);
	end;
end;

function HeapPreview:onStartMission()	
	if not HeapPreview:getServer() then 
		HeapPreview:searchOtherMods();
		HeapPreview.values.foundHlHudSystem = g_currentMission.hlHudSystem ~= nil and g_currentMission.hlHudSystem.hlHud ~= nil and g_currentMission.hlHudSystem.hlHud.generate ~= nil; --check is HL Hud System ready !
		if HeapPreview.values.foundHlHudSystem then loadScripts(2);hpGuiBoxSetGet:insertGuiBoxLines();g_currentMission.hlUtils.modLoad("FS25_HeapPreview");end;
	end;
end;

function HeapPreview:registerActionEvent()
	PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(
		PlayerInputComponent.registerGlobalPlayerActionEvents,
		function(self, controlling)
			if controlling ~= "VEHICLE" or HeapPreview.values.onVehicle then
				local inputAction = InputAction.HEAPPREVIEWONOFF;
				local callbackTarget = self;
				local callbackFunc = self.heapPreviewActionKeyMouse;
				local triggerUp = false;
				local triggerDown = true;
				local triggerAlways = false;
				local startActive = true;

				local _, eventId = g_inputBinding:registerActionEvent(inputAction, callbackTarget, callbackFunc, triggerUp, triggerDown, triggerAlways, startActive);

				--g_inputBinding:setActionEventText(eventId, g_i18n:getText("moh_HIDE"));
				g_inputBinding:setActionEventTextVisibility(eventId, false);
			end
	end)
	function PlayerInputComponent:heapPreviewActionKeyMouse(actionName, inputValue, callbackState, isAnalog, isMouse, deviceCategory)
		if g_currentMission.hlUtils == nil or not g_currentMission.hlUtils.dragDrop.on then
			if actionName == "HEAPPREVIEWONOFF" then			
				HeapPreview.values.isOn = not HeapPreview.values.isOn;
				local text = g_i18n:getText("ui_off");
				if HeapPreview.values.isOn then text = g_i18n:getText("ui_on").. " (Radius ".. tostring(HeapPreview.values.radius).. ")";end;
				g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, tostring(HeapPreview.metadata.title).. ": ".. tostring(text), 2500);
			end;
		end;
	end;
end;

function HeapPreview:deleteMap()
	if HeapPreview:getServer() then return;end;
	HeapPreview:saveSettings();
end;

function HeapPreview:mouseEvent(posX, posY, isDown, isUp, button)
	
end;

function HeapPreview:keyEvent(unicode, sym, modifier, isDown)
	
end;

function HeapPreview:update(dt)	
	if HeapPreview:getServer() or hpSetGet:getMapState(true,true) then return;end;
	if not HeapPreview.values.isOn then return;end;
	if not HeapPreview:getPlayerData() then 
		hpSetGet:searchHeaps();
		if HeapPreview.values.foundHeap then
			hpSetGet:showInfoBoxOrText(true);
		else
			hpSetGet:showInfoBoxOrText(false);		
		end;
	end;
end;

function HeapPreview:draw(dt)
	if HeapPreview:getServer() or hpSetGet:getMapState(true,true) then return;end;
	if HeapPreview.values.isOn and HeapPreview.values.viewDebugCircle then setDebugCircle();end;
end;	
addModEventListener(HeapPreview);

function HeapPreview:searchOtherMods()	
	--local env = getfenv(0);		
	
end;

function loadScripts(int)
	if int == 1 then		
		source(HeapPreview.modDir.."defaultSettings/hpLoadTables.lua");
		source(HeapPreview.modDir.."defaultSettings/hpSetGetSettingsXml.lua");
		source(HeapPreview.modDir.."scripte/hpSetGet.lua");		
	end;
	if int == 2 then
		source(HeapPreview.modDir.."scripte/hpGuiBoxSetGet.lua");
	end;
end;

function setDebugCircle()
	if g_localPlayer ~= nil then
		if g_localPlayer.rootNode == nil then return;end; --MP Join Event
		if g_localPlayer:getIsInVehicle() then return;end;
	end;
	return;
end;

function HeapPreview:getPlayerData(node)
	if g_localPlayer ~= nil then 
		if node then return g_localPlayer.rootNode;else return g_localPlayer:getIsInVehicle();end;
	end;
	return nil;
end;

function HeapPreview:getServer()
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function HeapPreview:saveSettings()
	hpSetGetSettingsXml:saveConfig();	
end;

function HeapPreview:loadSettings()
	hpSetGetSettingsXml:loadConfig();	
end;