SpeedMeterDisplay.draw = Utils.appendedFunction(SpeedMeterDisplay.draw, function(self, ...)
    local vehicle = self.vehicle
    if vehicle ~= nil and self.isVehicleDrawSafe and vehicle.getDamageAmount ~= nil and vehicle:getDamageAmount() ~= nil then
        local damageValue = 1
        local vehicles = vehicle.rootVehicle.childVehicles
        for _, subVehicle in ipairs(vehicles) do
            if subVehicle.getDamageShowOnHud ~= nil and subVehicle:getDamageShowOnHud() and (vehicle.getIsSelected ~= nil and subVehicle:getIsSelected()) then
                damageValue = math.min(damageValue, 1 - subVehicle:getDamageAmount())
				break
            end
        end

        if damageValue > 0 then
            if damageValue > 0.2 then
                self.bar:setColor(0.0097, 0.4287, 0.6445, 1)
            else
                self.bar:setColor(1, 0.1233, 0, 1)
            end

            local barScale = math.clamp(self.barMaxScaleWidth * damageValue, 0, self.barMaxScaleWidth)
            self.bar:setMiddlePart(nil, barScale, nil)
		else
			self.bar:setColor(0, 0, 0, 1)
			self.bar:setMiddlePart(nil, self.barMaxScaleWidth, nil)
        end
		self.bar:render()
	end
end)
